<?php
/**
 * Functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Guachipelin
 * @since 1.0.0
 */

/**
 * Enqueue the style.css file.
 * 
 * @since 1.0.0
 */
function guachipelin_style() {
	wp_enqueue_style(
		'guachipelin-style',
		get_stylesheet_uri(),
		array(),
		wp_get_theme()->get( 'Version' )
	);
}
add_action( 'wp_enqueue_scripts', 'guachipelin_style' );

$theme_blocks = __DIR__ . '/blocks/';
if ( is_readable( $theme_blocks ) ) {
	require_once $theme_blocks;
}
// Cambiar el correo del remitente
function personalizar_wp_mail_from($email) {
    return 'prendas52@gmail.com'; // Cambia esto al correo que deseas usar
}
add_filter('wp_mail_from', 'personalizar_wp_mail_from');

// Cambiar el nombre del remitente
function personalizar_wp_mail_from_name($name) {
    return 'Tu Nombre o Nombre de la Empresa'; // Cambia esto al nombre que deseas mostrar
}
add_filter('wp_mail_from_name', 'personalizar_wp_mail_from_name');

function enviar_correo_cliente_acf($post_id) {
    if (get_post_type($post_id) != 'cliente') return;
	die("La función enviar_correo_cliente_acf se está ejecutando.");

    // Obtener los valores de los campos ACF
    $nombre = get_field('name', $post_id);
    $correo = get_field('email', $post_id);
    $codigo = get_field('code', $post_id);
    $link_archivo = get_field('file_link', $post_id);

    // Debug: Imprimir los valores en pantalla
    echo "<h3>Debugging información del cliente:</h3>";
    echo "<p><strong>Nombre:</strong> " . esc_html($nombre) . "</p>";
    echo "<p><strong>Email:</strong> " . esc_html($correo) . "</p>";
    echo "<p><strong>Código de descarga:</strong> " . esc_html($codigo) . "</p>";
    echo "<p><strong>Enlace de archivo:</strong> " . esc_url($link_archivo) . "</p>";

    // Evitar que se envíe el correo durante la depuración
    return;

    // Código para enviar el correo (quitar el 'return;' anterior cuando termines de debuggear)
    if ($correo && $codigo && $link_archivo) {
        $asunto = "Acceso a sus fotos";
        $mensaje = "Hola " . esc_html($nombre) . ",\n\nGracias por confiar en nosotros.\n\n";
        $mensaje .= "Su código de acceso para descargar sus fotos es: " . esc_html($codigo) . "\n\n";
        $mensaje .= "Puede acceder a sus fotos en el siguiente enlace: " . esc_url($link_archivo) . "\n\n";
        $mensaje .= "Saludos,\nEl equipo de [Tu Empresa]";

        wp_mail($correo, $asunto, $mensaje);
    }
}

function agregar_boton_enviar_correo_acf() {
    global $post;

    if ($post->post_type == 'cliente') {
        $url = admin_url('admin-post.php?action=enviar_correo_cliente_acf&post_id=' . $post->ID);
        echo '<a href="' . esc_url($url) . '" class="button button-primary">Enviar correo al cliente</a>';
    }
}
add_action('edit_form_after_title', 'agregar_boton_enviar_correo_acf');
function procesar_envio_correo_cliente_acf() {
    if (isset($_GET['post_id'])) {
        $post_id = intval($_GET['post_id']);
        enviar_correo_cliente_acf($post_id);
        wp_redirect(get_edit_post_link($post_id) . '&correo_enviado=true');
        exit;
    }
}
add_action('admin_post_enviar_correo_cliente_acf', 'procesar_envio_correo_cliente_acf');

// enviar_correo_cliente_acf(112); // Reemplaza 123 con el ID de un cliente real


