import { useBlockProps } from '@wordpress/block-editor';

export default function save({ attributes }) {
  const { categories, description } = attributes;

  return (
    <section {...useBlockProps.save()} className="session-categories">
      <div className="session-categories__grid">
        {categories.map((category, index) => (
          <div key={index} className="session-card">
            <img
              className="session-card__image"
              src={category.imageUrl}
              alt={category.alt}
            />
            <div className="session-card__overlay">
              <h3 className="session-card__title">{category.title}</h3>
            </div>
          </div>
        ))}
      </div>
      <div className="session-categories__description">
        <p className="session-categories__text">{description}</p>
      </div>
    </section>
  );
}
