import { __ } from '@wordpress/i18n';
import { useBlockProps, RichText, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl } from '@wordpress/components';
import './editor.scss';

export default function Edit({ attributes, setAttributes }) {
  const { title, location, region, steps } = attributes;

  const updateStep = (index, key, value) => {
    const newSteps = [...steps];
    newSteps[index][key] = value;
    setAttributes({ steps: newSteps });
  };

  return (
    <div {...useBlockProps()}>
      <InspectorControls>
        <PanelBody title={__('Hero Section Settings', 'hero-section')}>
          <TextControl
            label={__('Location', 'hero-section')}
            value={location}
            onChange={(value) => setAttributes({ location: value })}
          />
          <TextControl
            label={__('Region', 'hero-section')}
            value={region}
            onChange={(value) => setAttributes({ region: value })}
          />
          {steps.map((step, index) => (
            <div key={index}>
              <TextControl
                label={__('Step Title', 'hero-section')}
                value={step.title}
                onChange={(value) => updateStep(index, 'title', value)}
              />
              <TextControl
                label={__('Step Description', 'hero-section')}
                value={step.description}
                onChange={(value) => updateStep(index, 'description', value)}
              />
            </div>
          ))}
        </PanelBody>
      </InspectorControls>

      <section className="hero">
        <div className="hero__container">
          <div className="hero__content">
            {/* Columna izquierda */}
            <div className="hero__left-column">
              <div className="location-tag">
                <div className="location-tag__text">
                  <span className="location-tag__primary">{location}</span>
                  <span className="location-tag__secondary">{region}</span>
                </div>
              </div>
              <RichText
                tagName="h1"
                className="hero__title"
                value={title}
                onChange={(value) => setAttributes({ title: value })}
                placeholder={__('Add your hero title', 'hero-section')}
              />
              <div className="steps">
                {steps.map((step, index) => (
                  <div key={index} className="step">
                    <div className="step__icon">{step.icon}</div>
                    <div className="step__title">{step.title}</div>
                    <div className="step__description">{step.description}</div>
                  </div>
                ))}
              </div>
            </div>

            {/* Columna derecha con el formulario de reserva */}
            <div className="hero__right-column">
              <div className="booking-card">
                <h2 className="booking-card__title">Reserva tu Foto</h2>
                <div className="booking-card__status">
                  <div className="booking-card__status-icon">✓</div>
                  <span>Disponible para reservar</span>
                </div>
                <form className="booking-card__form">
                  <div className="form-group">
                    <input
                      type="email"
                      id="email"
                      className="form-group__input"
                      placeholder="Tu correo electrónico"
                      required
                    />
                  </div>
                  <div className="form-group">
                    <input
                      type="tel"
                      id="phone"
                      className="form-group__input"
                      placeholder="Tu número telefónico"
                      required
                    />
                  </div>
                  <div className="form-group">
                    <input
                      type="date"
                      id="date"
                      className="form-group__input"
                      required
                    />
                  </div>
                  <p className="booking-card__info-text">
                    Al hacer clic en "Reservar", aceptas nuestros términos y condiciones. Recibirás un correo electrónico de confirmación con los detalles de tu reserva.
                  </p>
                  <p className="booking-card__info-text">
                    Nota: La reserva está sujeta a disponibilidad. Te recomendamos reservar con al menos 48 horas de anticipación para garantizar tu sesión fotográfica en Guachipelín.
                  </p>
                  <button type="submit" className="button button--search">
                    Reservar
                  </button>
                </form>
              </div>
            </div>
          </div>
        </div>
      </section>
    </div>
  );
}
