import { useBlockProps } from '@wordpress/block-editor';

export default function save({ attributes }) {
  const { links } = attributes;

  return (
    <nav {...useBlockProps.save()}>
      {/* Botón de menú hamburguesa para abrir/cerrar el menú en dispositivos móviles */}
      <button className="nav__mobile-menu-button" aria-label="Abrir menú">
        ☰
      </button>

      {/* Contenedor de navegación que incluye los enlaces */}
      <div className="nav">
        <div className="nav__group">
          {links.slice(0, 2).map((link, index) => (
            <a
              key={index}
              href={link.url}
              className={`nav__button ${link.isActive ? 'nav__button--active' : ''} ${link.isDropdown ? 'nav__button--dropdown' : ''}`}
            >
              {link.title}
            </a>
          ))}
        </div>
        {links.slice(2).map((link, index) => (
          <a
            key={index + 2}
            href={link.url}
            className={`nav__button ${link.isActive ? 'nav__button--active' : ''} ${link.isDropdown ? 'nav__button--dropdown' : ''}`}
          >
            {link.title}
          </a>
        ))}
      </div>
    </nav>
  );
}
