import { __ } from '@wordpress/i18n';
import { useBlockProps, InspectorControls } from '@wordpress/block-editor';
import { PanelBody, TextControl, Button, ToggleControl } from '@wordpress/components';
import { Fragment, useState } from '@wordpress/element';

export default function Edit({ attributes, setAttributes }) {
  const { links } = attributes;
  const [menuOpen, setMenuOpen] = useState(false);

  // Función para alternar el estado del menú (abierto/cerrado)
  const toggleMenu = () => {
    setMenuOpen(prevState => !prevState); // Cambia el estado del menú (abierto/cerrado)
    console.log("Hamburger menu clicked"); // Debug para confirmar la ejecución del evento
  };

  return (
    <Fragment>
      <InspectorControls>
        <PanelBody title={__('Enlaces de Navegación', 'guachipelin-theme')}>
          {links.map((link, index) => (
            <div key={index} style={{ marginBottom: '20px' }}>
              <TextControl
                label={__('Título del Enlace', 'guachipelin-theme')}
                value={link.title}
                onChange={(value) => {
                  const newLinks = [...links];
                  newLinks[index].title = value;
                  setAttributes({ links: newLinks });
                }}
              />
              <TextControl
                label={__('URL del Enlace', 'guachipelin-theme')}
                value={link.url}
                onChange={(value) => {
                  const newLinks = [...links];
                  newLinks[index].url = value;
                  setAttributes({ links: newLinks });
                }}
              />
              <ToggleControl
                label={__('¿Enlace Activo?', 'guachipelin-theme')}
                checked={link.isActive}
                onChange={(value) => {
                  const newLinks = [...links];
                  newLinks[index].isActive = value;
                  setAttributes({ links: newLinks });
                }}
              />
              <ToggleControl
                label={__('¿Es Desplegable?', 'guachipelin-theme')}
                checked={link.isDropdown}
                onChange={(value) => {
                  const newLinks = [...links];
                  newLinks[index].isDropdown = value;
                  setAttributes({ links: newLinks });
                }}
              />
            </div>
          ))}
          <Button
            variant="primary"
            onClick={() => {
              const newLinks = [
                ...links,
                { title: 'Nuevo Enlace', url: '#', isActive: false, isDropdown: false }
              ];
              setAttributes({ links: newLinks });
            }}
            style={{ marginTop: '10px' }}
          >
            {__('Añadir Enlace', 'guachipelin-theme')}
          </Button>
        </PanelBody>
      </InspectorControls>

      <nav {...useBlockProps()}>
        <button
          className="nav__mobile-menu-button"
          aria-label="Abrir menú"
          onClick={toggleMenu}
        >
          ☰
        </button>
        <div className={`nav ${menuOpen ? 'nav--open' : ''}`}>
          <button
            className="nav__close-button"
            aria-label="Cerrar menú"
            onClick={toggleMenu}
          >
            ✖
          </button>
          <div className="nav__group">
            {links.slice(0, 2).map((link, index) => (
              <a
                key={index}
                href={link.url}
                className={`nav__button ${link.isActive ? 'nav__button--active' : ''} ${link.isDropdown ? 'nav__button--dropdown' : ''}`}
              >
                {link.title}
              </a>
            ))}
          </div>
          {links.slice(2).map((link, index) => (
            <a
              key={index + 2}
              href={link.url}
              className={`nav__button ${link.isActive ? 'nav__button--active' : ''} ${link.isDropdown ? 'nav__button--dropdown' : ''}`}
            >
              {link.title}
            </a>
          ))}
        </div>
      </nav>
    </Fragment>
  );
}
